% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_freqWordCor.R
\name{getMostFreqWordCor}
\alias{getMostFreqWordCor}
\title{Test for correlation between the most frequent words.}
\usage{
getMostFreqWordCor(
  wordF,
  numWords,
  getPlot = c(TRUE, TRUE),
  getTextSink = TRUE,
  mwidth = 1024,
  mheight = 1024,
  formatType = "png"
)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{numWords}{The number of words to be returned.}

\item{getPlot}{A vector with two logical values. If \code{plots[1]==TRUE},
an image of the correlation matrix is saved in the RESULTS directory.
If \code{plots[2]==TRUE}, the image of the p-value matrix associated
with the correlation is saved in the RESULTS directory.}

\item{getTextSink}{If \code{TRUE}, save the correlation matrix and the
associated p-values in a text file in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\value{
A list with the correlation matrix and the p-value matrix.
}
\description{
Test for correlation between the most frequent words.
}
\examples{
data("wordOccuDF")
getMostFreqWordCor(
  wordF = wordOccuDF, 
  numWords = 5, 
  getPlot = c(FALSE, FALSE), 
  getTextSink = FALSE)
}
