% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-diagram-test.R
\name{two_sample_diagram_test}
\alias{two_sample_diagram_test}
\title{Two-sample test for diagram representation of persistence homology data}
\usage{
two_sample_diagram_test(
  x,
  y,
  dimension = 0L,
  p = 2L,
  ncores = 1L,
  B = 1000L,
  stat_functions = list(flipr::stat_t_ip, flipr::stat_f_ip),
  npc = "tippett",
  seed = NULL,
  verbose = FALSE,
  keep_null_distribution = FALSE,
  keep_permutations = FALSE
)
}
\arguments{
\item{x}{An object of class \code{persistence_set} typically produced by
\code{\link[phutil:persistence-set]{phutil::as_persistence_set()}} or of class \code{dist} typically produced by
\code{\link[phutil:pairwise-distances]{phutil::bottleneck_pairwise_distances()}} or
\code{\link[phutil:pairwise-distances]{phutil::wasserstein_pairwise_distances()}}. If \code{x} is a persistence set,
then \code{y} must be either a vector of two integers (sample sizes) or another
persistence set. If \code{x} is a distance matrix, then \code{y} must be a vector of
two integers (sample sizes).}

\item{y}{An object of class \code{persistence_set} typically produced by
\code{\link[phutil:persistence-set]{phutil::as_persistence_set()}} or a vector of two integers. If \code{x} is a
persistence set, then \code{y} must be either a vector of two integers (sample
sizes) or another persistence set. If \code{x} is a distance matrix, then \code{y}
must be a vector of two integers (sample sizes).}

\item{dimension}{An integer value specifying the homology dimension to use.
Defaults to \code{0L}, which corresponds to the 0-dimensional homology.}

\item{p}{An integer value specifying the p-norm to use for the Wasserstein
distance. Defaults to \code{2L}, which corresponds to the Euclidean distance. If
\code{p} is set to \code{Inf}, then the Bottleneck distance is used.}

\item{ncores}{An integer value specifying the number of cores to use when
computing the pairwise distance matrix between all combined persistence
diagrams. Defaults to \code{1L}, which means that the computation is done
sequentially.}

\item{B}{An integer value specifying the number of permutations to use for
the permutation hypothesis test. Defaults to \code{1000L}.}

\item{stat_functions}{A list of functions that compute test statistics to be
used for solving the inference problem. These functions must take two
arguments: first, an object of class \code{dist} representing a distance matrix
and second, an integer vector specifying the indices of the data points
belonging to the first sample. Defaults to
\verb{list(flipr::stat_t_ip, flipr::stat_f_ip})` which are distance-based
statistics equivalent to Student's and Fisher's statistics respectively.}

\item{npc}{A string specifying the non-parametric combination method to use.
Choices are either \code{"tippett"} (default) or \code{"fisher"}. The former
corresponds to the Tippet's method, while the latter corresponds to
Fisher's method.}

\item{seed}{An integer value specifying the seed for random number
generation. Defaults to \code{NULL} which uses current time.}

\item{verbose}{A boolean value indicating whether to print some information
about the progress of the computation. Defaults to \code{FALSE}.}

\item{keep_null_distribution}{A boolean specifying whether the empirical
permutation null distribution should be returned as well. Defaults to
\code{FALSE}.}

\item{keep_permutations}{A boolean specifying whether the list of sampled
permutations used to compute the empirical permutation null distribution
should be returned as well. Defaults to \code{FALSE}.}
}
\value{
A numeric value storing the p-value from the two-sample test where
the null hypothesis is that the two samples come from the same
distribution. If one of \code{keep_null_distribution} or \code{keep_permutations} is
set to \code{TRUE}, then the output will be a list containing the p-value and
the null distribution (if \code{keep_null_distribution} is set to \code{TRUE}) and
the list of sampled permutations (if \code{keep_permutations} is set to \code{TRUE}).
}
\description{
This function performs a two-sample test for persistence homology data using
the theory of permutation hypothesis testing to test the null hypothesis that
the two samples come from the same distribution. The inference is performed
using test statistics that only involve distances between persistence diagrams.
Hence, the input data can be either a persistence set or a precomputed
distance matrix.
}
\examples{
two_sample_diagram_test(trefoils1[1:5], trefoils2[1:5], B = 100L)
two_sample_diagram_test(trefoils1[1:5], archspirals[1:5], B = 100L)
}
\references{
Lovato, I., Pini, A., Stamm, A., & Vantini, S. (2020). Model-free two-sample test for network-valued data. Computational Statistics & Data Analysis, 144, 106896.
}
