% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install.CMake}
\alias{install.CMake}
\alias{install.cmake}
\title{Downloads and installs CMake for windows}
\usage{
install.CMake(
  URL = "https://github.com/Kitware/CMake/releases",
  cmake_version = NULL,
  ...
)
}
\arguments{
\item{URL}{the URL of the CMake download page.}

\item{cmake_version}{NULL by default, but a user can supply the version as a character.}

\item{...}{extra parameters to pass to \link{install.URL}}
}
\value{
TRUE/FALSE - was the installation successful or not.
}
\description{
Allows the user to downloads and install the latest version of CMake for Windows.
}
\details{
CMake is a family of tools designed to build, test and package software. 
CMake is used to control the software compilation process using simple 
platform and compiler independent configuration files. 
CMake generates native makefiles and workspaces that can be used in the 
compiler environment of your choice.
If run NOT on Windows (i.e.: max/linux), this would download the file into the working directory.
(\link{getwd}).
}
\examples{
\dontrun{
install.CMake() # installs the latest version of CMake
}

}
\references{
\itemize{
\item CMake homepage: \url{https://cmake.org/download/}
}
}
