% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{eventCourse}
\alias{eventCourse}
\title{Scheduling interim analyses in clinical trials for time-to-event settings}
\usage{
eventCourse(r, e1 = NULL, lp = "topright")
}
\arguments{
\item{r}{recruitment scenario calculated with function \code{recruitment}.}

\item{e1}{\emph{optional}. Event simulation from function \code{event}.}

\item{lp}{\emph{optional}. Position of legend, specified by keyword: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", or "center".}
}
\description{
Function \code{eventCourse} plots the results of function \code{recruitment}
and function \code{event}.
}
\details{
Function \code{eventCourse} produces two plots to display results of enrollment
and treatment simulations.

The first plot displays the cumulative number of centers that have been opened
as well as the cumulative number of centers that have been closed, if applicable, per trial week.

The second plot displays the number of patients that have been screened and enrolled per trial week.
If the parameter \code{e1} is not \code{NULL}, then
the number of events and the number of drop-outs before first event ist displayed.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=event(r=x,er=0.12,dr=0.08,du=50)
eventCourse(r=x,e1=y)
}
\seealso{
\code{\link{event}} for simulating the events for a given recruitment scenario;
\code{\link{recruitment}} for simulating recruitment scenarios.
}
