% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoubleCenter.R
\name{DoubleCenter}
\alias{DoubleCenter}
\alias{transform,DoubleCenter,sparseMatrix-method}
\alias{inverse_transform,DoubleCenter,sparseLRMatrix-method}
\alias{inverse_transform,DoubleCenter,vsp_fa-method}
\title{Construct and use DoubleCenter transformations}
\usage{
DoubleCenter(A)

\S4method{transform}{DoubleCenter,sparseMatrix}(iform, A)

\S4method{inverse_transform}{DoubleCenter,sparseLRMatrix}(iform, A)

\S4method{inverse_transform}{DoubleCenter,vsp_fa}(iform, A)
}
\arguments{
\item{A}{A matrix to transform.}

\item{iform}{An \linkS4class{Invertiform} object describing the transformation.}
}
\value{
\itemize{
\item \code{DoubleCenter()} creates a \linkS4class{DoubleCenter} object.
\item \code{transform()} returns the transformed matrix,
typically as a \link[sparseLRMatrix:sparseLRMatrix-class]{sparseLRMatrix::sparseLRMatrix}.
\item \code{inverse_transform()} returns the inverse transformed matrix,
typically as a \link[sparseLRMatrix:sparseLRMatrix-class]{sparseLRMatrix::sparseLRMatrix} in most cases.
When possible reduces the \link[sparseLRMatrix:sparseLRMatrix-class]{sparseLRMatrix::sparseLRMatrix} to a
\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}}.
}
}
\description{
A convenience function to create \linkS4class{DoubleCenter} S4 objects,
which are useful for \strong{simultaneously row and column centering}
a matrix.
}
\examples{

library(igraph)
library(igraphdata)

data("karate", package = "igraphdata")

A <- get.adjacency(karate)

iform <- DoubleCenter(A)

A_tilde <- transform(iform, A)
A_recovered <- inverse_transform(iform, A_tilde)

all.equal(A, A_recovered)

}
