% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fup_uc_L2_heldout}
\alias{fup_uc_L2_heldout}
\title{Fup UC Level-2 Heldout Example Data set}
\format{
A level-2 data.frame with 0 rows and 24 variables: \describe{
\item{\code{Lab.Sample.Name}}{Sample description used in the laboratory}
\item{\code{Date}}{Date the sample was added to the MS analyzer}
\item{\code{Compound.Name}}{Name of the test analyte/compound}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard - CCD)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Sample.Type}}{Type of UC sample}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
\item{\code{Calibration}}{Identifier for mass spectrometry calibration -- usually the date}
\item{\code{ISTD.Name}}{Name of the internal standard (ISTD) analyte/compound}
\item{\code{ISTD.Conc}}{Concentration of ISTD (uM)}
\item{\code{ISTD.Area}}{Peak area of internal standard (ISTD) compound (pixels)}
\item{\code{Area}}{Peak area of analyte (target compound)}
\item{\code{Analysis.Method}}{General description of chemical analysis method}
\item{\code{Analysis.Instrument}}{Instrument(s) used for chemical analysis}
\item{\code{Analysis.Parameters}}{Parameters for identifing analyte peak (for example, retention time)}
\item{\code{Note}}{Any laboratory notes about sample}
\item{\code{Level0.File}}{Name of the laboratory data file from which the level-0 sample data was extracted}
\item{\code{Level0.Sheet}}{Name of the Excel workbook 'sheet' from which the level-0 sample data was extracted}
\item{\code{Test.Compound.Conc}}{Measured concentration of analytic standard (for calibration curve) (uM)}
\item{\code{Test.Nominal.Conc}}{Expected initial concentration of chemical added to T1 sample (uM)}
\item{\code{Biological.Replicates}}{Identifier for measurements of multiple samples with the same analyte}
\item{\code{Technical.Replicates}}{Identifier for repeated measurements of one sample of a compound}
\item{\code{Response}}{Response factor (calculated from analyte and ISTD peaks)}
\item{\code{Verified}}{If "Y", then sample is included in the analysis. (Any other value causes the data to be ignored.)}
}
}
\usage{
fup_uc_L2_heldout
}
\description{
The unverified level-2 samples from mass spectrometry measurements of plasma protein binding (PPB) via 
ultracentrifugation (UC) for per- and poly-fluorinated alkyl substance
(PFAS) samples. Experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. 
This data set is a subset of experimental data containing samples for 
0 test analytes/compounds. No data samples are unverified.
}
\references{
\insertRef{howard2010plasma}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{data}
