% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_answer_options.R
\name{get_answer_options}
\alias{get_answer_options}
\title{get_answer_options}
\usage{
get_answer_options(question_code)
}
\arguments{
\item{question_code}{Code by which to identify the question.
Follows a dot-based naming scheme:
<group title>.<subquestion title>.}
}
\value{
`data.frame` object with the columns `code` and `answer` in which
each row represents one answer option where `code` is the encoded value (as
found in datasets exported by `get_survey_data()` and `answer` is the answer
option text as seen by survey users).
}
\description{
Get the answer options to a question with pre-defined answer
options (e.g. a multiple choice question).
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the ID 123456.
# In this survey, a multiple-choice question identified by the code "bdi.01"
# is used.
# For this question, this example retrieves the possible answer options.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_table_prefix = '',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

answer_options <- get_answer_options("bdi.01")
}

}
