% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_plusplus_ols.R
\name{ppi_plusplus_ols_est}
\alias{ppi_plusplus_ols_est}
\title{PPI++ OLS (Point Estimate)}
\usage{
ppi_plusplus_ols_est(
  X_l,
  Y_l,
  f_l,
  X_u,
  f_u,
  lhat = NULL,
  coord = NULL,
  w_l = NULL,
  w_u = NULL
)
}
\arguments{
\item{X_l}{(matrix): n x p matrix of covariates in the labeled data.}

\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{X_u}{(matrix): N x p matrix of covariates in the unlabeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{lhat}{(float, optional): Power-tuning parameter (see
\url{https://arxiv.org/abs/2311.01453}). The default value, \code{NULL},
will estimate the optimal value from the data. Setting \code{lhat = 1}
recovers PPI with no power tuning, and setting \code{lhat = 0} recovers
the classical point estimate.}

\item{coord}{(int, optional): Coordinate for which to optimize
\code{lhat = 1}. If \code{NULL}, it optimizes the total variance over all
coordinates. Must be in (1, ..., d) where d is the dimension of the estimand.}

\item{w_l}{(ndarray, optional): Sample weights for the labeled data set.
Defaults to a vector of ones.}

\item{w_u}{(ndarray, optional): Sample weights for the unlabeled
data set. Defaults to a vector of ones.}
}
\value{
(vector): vector of prediction-powered point estimates of the OLS
coefficients.
}
\description{
Helper function for PPI++ OLS estimation (point estimate)
}
\details{
PPI++: Efficient Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://arxiv.org/abs/2311.01453}
}
\examples{

dat <- simdat(model = "ols")

form <- Y - f ~ X1

X_l <- model.matrix(form, data = dat[dat$set_label == "labeled",])

Y_l <- dat[dat$set_label == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set_label == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

X_u <- model.matrix(form, data = dat[dat$set_label == "unlabeled",])

f_u <- dat[dat$set_label == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_plusplus_ols_est(X_l, Y_l, f_l, X_u, f_u)

}
