% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathdistGen.R
\name{pathdistGen}
\alias{pathdistGen}
\title{Generate a stack of path distance raster objects}
\usage{
pathdistGen(sf_ob, costras, range, yearmon = "default", progressbar = TRUE)
}
\arguments{
\item{sf_ob}{sf object with point geometries}

\item{costras}{RasterLayer cost raster}

\item{range}{numeric. Range of interpolation neighborhood}

\item{yearmon}{character. String specifying the name of the sf_ob}

\item{progressbar}{logical show progressbar during processing?}
}
\value{
RasterStack object of path distances
}
\description{
Generate a stack of path accumulated distance raster objects
}
\examples{
library(sf)
sf_ob <- data.frame(rnorm(2))
xy   <- data.frame(x = c(4, 2), y = c(8, 4))
sf_ob <- st_as_sf(cbind(sf_ob, xy), coords = c("x", "y"))

m <- matrix(NA, 10, 10)
costras <- raster(m, xmn = 0, xmx = ncol(m), ymn = 0, ymx = nrow(m))
costras[] <- runif(ncell(costras), min = 1, max = 10)
# introduce spatial gradient
for (i in 1:nrow(costras)) {
  costras[i, ] <- costras[i, ] + i
  costras[, i] <- costras[, i] + i
}

rstack <- pathdistGen(sf_ob, costras, 100, progressbar = FALSE)
}
