% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imemSFS.R
\name{imemSFS}
\alias{imemSFS}
\title{Spherical indeterminacy membership function}
\usage{
imemSFS(m, nm)
}
\arguments{
\item{m}{SFS membership values computed using either triangular or trapezoidal or guassian membership function}

\item{nm}{SFS non-membership values computed using either Sugeno and Terano's  or Yager's non-membership function}
}
\value{
SFS indeterminacy membership values
}
\description{
Spherical indeterminacy membership values with membership and non-membership values as input
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
a<-mn(x)
b<-std(x)
m<-memG(a,b,x)
lam<-0.5
nm<-nonmemS(m,lam)
imemSFS(m,nm)
#        [,1]       [,2]       [,3]
#[1,] 0.09921264 0.05810582 0.03270001
#[2,] 0.09915966 0.03100937 0.05966479
#[3,] 0.04565299 0.09939456 0.04565299
#[4,] 0.04565299 0.09939456 0.04565299
}
