% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{define_extract_nhgis}
\alias{define_extract_nhgis}
\title{Define an IPUMS NHGIS extract request}
\usage{
define_extract_nhgis(
  description = "",
  datasets = NULL,
  time_series_tables = NULL,
  shapefiles = NULL,
  geographic_extents = NULL,
  breakdown_and_data_type_layout = NULL,
  tst_layout = NULL,
  data_format = NULL
)
}
\arguments{
\item{description}{Description of the extract.}

\item{datasets}{List of dataset specifications for any
\href{https://www.nhgis.org/overview-nhgis-datasets}{datasets}
to include in the extract request. Use \code{\link[=ds_spec]{ds_spec()}} to create a
\code{ds_spec} object containing a dataset specification. See examples.}

\item{time_series_tables}{List of time series table specifications for any
\href{https://www.nhgis.org/time-series-tables}{time series tables}
to include in the extract request. Use \code{\link[=tst_spec]{tst_spec()}} to create a
\code{tst_spec} object containing a time series table specification. See
examples.}

\item{shapefiles}{Names of any \href{https://www.nhgis.org/gis-files}{shapefiles}
to include in the extract request.}

\item{geographic_extents}{Vector of geographic extents to use for
all of the \code{datasets} and \code{time_series_tables} in the extract
definition (for instance, to obtain data within a specified state).
By default, selects all available extents.

Use \code{\link[=get_metadata]{get_metadata()}} to identify the available extents for a given
dataset or time series table, if any.}

\item{breakdown_and_data_type_layout}{The desired layout
of any \code{datasets} that have multiple data types or breakdown values.
\itemize{
\item \code{"single_file"} (default) keeps all data types and breakdown values in
one file
\item \code{"separate_files"} splits each data type or breakdown value into its
own file
}

Required if any \code{datasets} included in the extract definition consist of
multiple data types (for instance, estimates and margins of error) or have
multiple breakdown values specified. See \code{\link[=get_metadata]{get_metadata()}} to
determine whether a requested dataset has multiple data types.}

\item{tst_layout}{The desired layout of all \code{time_series_tables} included in
the extract definition.
\itemize{
\item \code{"time_by_column_layout"} (wide format, default): rows correspond to
geographic units, columns correspond to different times in the time
series
\item \code{"time_by_row_layout"} (long format): rows correspond to a single
geographic unit at a single point in time
\item \code{"time_by_file_layout"}: data for different times are provided in
separate files
}

Required when an extract definition includes any \code{time_series_tables}.}

\item{data_format}{The desired format of the extract data file.
\itemize{
\item \code{"csv_no_header"} (default) includes only a minimal header in the first
row
\item \code{"csv_header"} includes a second, more descriptive header row.
\item \code{"fixed_width"} provides data in a fixed width format
}

Note that by default, \code{\link[=read_ipums_agg]{read_ipums_agg()}} removes the additional header row
in \code{"csv_header"} files.

Required when an extract definition includes any \code{datasets} or
\code{time_series_tables}.}
}
\value{
An object of class \code{\link[=ipums_extract-class]{nhgis_extract}} containing
the extract definition.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Define the parameters of an IPUMS NHGIS extract request to be submitted via
the IPUMS API.

This function has been deprecated in favor of \code{\link[=define_extract_agg]{define_extract_agg()}},
which can be used to define extracts for both IPUMS aggregate data
collections (IPUMS NHGIS and IPUMS IHGIS). Please use that function instead.

All NHGIS extract request parameters supported by \code{define_extract_nhgis()}
are supported by \code{define_extract_agg()}.

Learn more about the IPUMS API in \code{vignette("ipums-api")} and
NHGIS extract definitions in \code{vignette("ipums-api-agg")}.
}
\examples{
# Previously, you could create an NHGIS extract definition like so:
nhgis_extract <- define_extract_nhgis(
  description = "Example NHGIS extract",
  datasets = ds_spec(
    "1990_STF3",
    data_tables = "NP57",
    geog_levels = c("county", "tract")
  )
)

# Now, use the following:
nhgis_extract <- define_extract_agg(
  collection = "nhgis",
  description = "Example NHGIS extract",
  datasets = ds_spec(
    "1990_STF3",
    data_tables = "NP57",
    geog_levels = c("county", "tract")
  )
)
}
\seealso{
\code{\link[=get_metadata_catalog]{get_metadata_catalog()}} to find data to include in an extract definition.

\code{\link[=submit_extract]{submit_extract()}} to submit an extract request for processing.

\code{\link[=save_extract_as_json]{save_extract_as_json()}} and \code{\link[=define_extract_from_json]{define_extract_from_json()}} to share an
extract definition.
}
\keyword{internal}
