% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_export_prepare.R
\name{ir_export_prepare}
\alias{ir_export_prepare}
\title{Prepares \code{ir} objects for export to \code{csv}}
\usage{
ir_export_prepare(
  x,
  what = "metadata",
  measurement_id = as.character(seq_len(nrow(x)))
)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{what}{A character value defining what to prepare for export.
If \code{"metadata"}, the metadata will be prepared for export and column
\code{spectra} will be dropped. If \code{"spectra"}, \code{x} is converted to an object of
class \code{\link[=ir_new_ir_flat]{ir_flat}}.}

\item{measurement_id}{A character vector an element for each row in \code{x}
that contains the names to use as column names for the spectra in the
\code{ir_flat} object to create.}
}
\value{
A data frame.
}
\description{
Prepares \code{ir} objects for export to \code{csv} files. To export \code{ir} objects to
\code{csv}, the \code{spectra} column has to be converted to an own data frame and be
exported separately from the metadata.
When preparing metadata for export, \code{ir_export_prepare} takes care of
separating measurement units and measurement errors in columns of class
\link[units:units]{units::units}, \link[errors:errors]{errors::errors}, and \link[quantities:quantities]{quantities::quantities} (see the
examples).
}
\note{
This function superseded \code{irp_export_prepare()} from the
\href{https://github.com/henningte/irpeat/}{'irpeat'} package.
}
\examples{
x_spectra <- ir_export_prepare(ir_sample_data[1:5, ], what = "spectra")
x_metadata <- ir_export_prepare(ir_sample_data[1:5, ], what = "metadata")

}
