% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau.R
\name{tau}
\alias{tau}
\alias{tau_a}
\alias{tau_b}
\title{Kendall \eqn{\tau} Rank Correlation Coefficients}
\usage{
tau(x, y)

tau_a(x, y)

tau_b(x, y)
}
\arguments{
\item{x}{a numeric vector. In \code{tau_a} this is the vector of true scores.}

\item{y}{a numeric vector of the same length as \code{x}. In \code{tau_a} this is the vector of
estimated scores.}
}
\value{
The correlation coefficient.
}
\description{
\code{tau} is the rank correlation coefficient by Kendall, where neither vector can contain tied
items. \code{tau_a} and \code{tau_b} are the versions developed to cope with ties under the
scenarios of accuracy and agreement, respectively. See the references for details.
}
\examples{
# No ties
x <- c(0.67, 0.45, 0.29, 0.12, 0.57, 0.24, 0.94, 0.75, 0.08, 0.54)
y <- c(0.48, 0.68, 0.32, 0.09, 0.06, 0.61, 0.87, 0.22, 0.44, 0.84)
tau(x, y)
tau_a(x,y) # same as tau
tau_b(x,y) # same as tau

# Ties in y
y <- round(y, 1)
tau_a(x, y)
tau_b(x, y)

# Ties in x too
x <- round(x, 1)
tau_b(x, y)
}
\references{
M.G. Kendall (1970). Rank Correlation Methods. Charles Griffin & Company
  Limited.
}
\seealso{
\code{\link{tauAP}} for AP correlation coefficients.
}
