% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree.coeff3.dist.r
\name{pa.coeff.dist}
\alias{pa.coeff.dist}
\title{Percent agreement coefficient among multiple raters (2, 3, +) when the input dataset is the distribution of raters by subject and category.}
\source{
Brennan, R.L., and Prediger, D. J. (1981). ``Coefficient Kappa: some uses, misuses, and alternatives," 
\emph{Educational and Psychological Measurement}, 41, 687-699.
}
\usage{
pa.coeff.dist(ratings, weights = "unweighted", categ = NULL,
  conflev = 0.95, N = Inf)
}
\arguments{
\item{ratings}{An \emph{nxq} matrix / data frame containing the distribution of raters by subject and category. Each cell \emph{(i,k)} contains the number of raters who classsified subject \emph{i} into category \emph{k}.}

\item{weights}{is an optional parameter that is either a string variable or a matrix. The string describes one of the predefined 
weights and must take one of the values ("quadratic", "ordinal", "linear", "radical", "ratio", "circular", "bipolar"). 
If this parameter is a matrix then it must be a square matri qxq where q is the number of posssible categories where a subject 
can be classified. If some of the q possible categories are not used, then it is strobgly advised to specify the complete list of 
possible categories as a vector in parametr categ. Otherwise, only the categories reported will be used.}

\item{categ}{An optional parameter representing all categories available to raters during the experiment. This parameter may be useful if 
some categories were not used by any rater inspite of being available to the raters.}

\item{conflev}{An optional parameter representing the confidence level associated with the confidence interval. Its default value is 0.95.}

\item{N}{An optional parameter representing the population size (if any). It may be use to perform the final population correction to the variance.  Its default value is infinity.}
}
\value{
A vector containing the following information: 
pa(the percent agreement),pe(the percent chance agreement),coeff(Brennan-Prediger coefficient),
stderr(the standard error of Brennan-Prediger coefficient),conf.int(the p-value of Brennan-Prediger coefficient), 
p.value(the p-value of Brennan-Prediger coefficient),coeff.name ("Brennan-Prediger").
}
\description{
Percent agreement coefficient among multiple raters (2, 3, +) when the input dataset is the distribution of raters by subject and category.
}
\examples{
#The dataset "distrib.6raters" comes with this package. It represents the distribution of 6 raters 
#by subject and by category. Note that each row of this dataset sums to the number of raters, which
#is 6. You may this dataset as follows:
distrib.6raters
pa.coeff.dist(distrib.6raters) #percent agreement, precision measures, weights& list of categories
pa <- pa.coeff.dist(distrib.6raters)$coeff #Yields the percent agreement coefficient alone.
pa
q <- ncol(distrib.6raters) #Number of categories
pa.coeff.dist(distrib.6raters,weights = quadratic.weights(1:q)) #Weighted percent agreement
}
