% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{ci.ICC3r.inter}
\alias{ci.ICC3r.inter}
\title{Confidence Interval of ICC(3,1) under ANOVA Model 3 with Interaction.}
\usage{
ci.ICC3r.inter(dfra, conflev = 0.95)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{conflev}{This is the optional confidence level associated with the confidence interval. If not specified, the default value
will be 0.95, which is the most commonly-used valuee in the literature.}
}
\value{
This function returns a vector containing the lower confidence (lcb) and the upper confidence bound (ucb).
}
\description{
This function computes the confidence interval associated with the Intraclass Correlation Coefficient (ICC) as a measure of
inter-rater reliability under the mixed factorial ANOVA model with interaction. It produces the lower and upper confidence bounds.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
ci.ICC3r.inter(iccdata1)
ci.ICC3r.inter(iccdata1)$ucb #to get upper confidence bound only
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 10, section 10.3.1, equations
10.3.1 and 10.3.2. Advanced Analytics, LLC.
}
