% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{icc3.inter.fn}
\alias{icc3.inter.fn}
\title{Intraclass Correlation Coefficients (ICC) under the Mixed Factorial ANOVA model with Interaction.}
\usage{
icc3.inter.fn(dfra)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (some duplicates are expected,
as some subject are assumed to have assigned multiple ratings) and each of the remaining columns is associated with a particular rater and
contains its numeric ratings.}
}
\value{
This function returns a list containing the following 12 values:
1. sig2s: the subject variance component. 2.sig2r: the rater variance component 3. sig2e: the error variance component.
4. sig2sr: the subject-rater interaction variance component. 5. icc2r: ICC as a measure of inter-rater relliability.
6. icc2a: ICC as a measure of intra-rater reliability. 7. n: the number of subjects. 8. r: the number of raters.
9. max.rep: the maximum number of ratings per subject. 10. min.rep: the minimum number of ratings per subjects.
11. M: the total number of ratings for all subjects and raters. 12. ov.mean: the overall mean rating.
}
\description{
This function computes 2 ICC estimates ICC(3,1) and ICCa(3,1) as measures of inter-rater reliability and intra-rater reliability
coefficients under Model 3.  It is the the mixed factorial ANOVA model with interaction. Some subjects are expected to have
multiple ratings and due to the assumed interaction effect.
}
\examples{
#iccdata2 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata2 #see what the iccdata2 dataset looks like
icc3.inter.fn(iccdata2[,2:6]) #Here, you must omit the first column
coeff <- icc3.inter.fn(iccdata2[,2:6])$icc2a #this gives you intra-rater reliability coefficient
coeff
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} - Equation #10.2.9 of chapter 10, page 279
(for the inter-rater reliability ICC(3,1)), and Equation #10.2.10 of chapter 10, page 279 (for the intra-rater reliability ICCa(3,1)),
Advanced Analytics, LLC.
}
