% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{pvals.ICC2a.inter}
\alias{pvals.ICC2a.inter}
\title{P-values of ICCa(2,1) under Model 2 with interaction.}
\usage{
pvals.ICC2a.inter(dfra, gam.zero = 0)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more. The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{gam.zero}{This is an optional parameter that represents a vector containing an arbitrary number of null values between 0 and 1
for which a p-value will be calculated. If not specified then its default value will be 0.}
}
\value{
This function returns a vector containing p-values associated with the null values specified in the parameter gam.zero.
}
\description{
This function can compute several p-values associated with the Intraclass Correlation Coefficient (ICC) used to quantify intra-rater
reliability coefficient under the random factorial ANOVA model with subject-rater interaction (Model 2). This function computes
the p-value for each of the null values specified in the parameter gam.zero.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
pvals.ICC2a.inter(iccdata1,c(0.15,0.20,0.25))
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 9, section 9.3.2 (page 245)
Advanced Analytics, LLC.
}
