% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class-methods.R
\name{$<-,Itempool-method}
\alias{$<-,Itempool-method}
\title{Set values to parameters or components of 'Itempool' class.}
\usage{
\S4method{$}{Itempool}(x, name) <- value
}
\arguments{
\item{x}{\code{\link{Itempool-class}} object.}

\item{name}{Name of the parameter or component. Currently only \code{misc},
\code{item_id}, \code{id}, \code{content}, \code{item_list} are
available.}

\item{value}{The new value that will be assigned.
\describe{
  \item{\strong{\code{'item_id'}}}{For \code{item_id}, the value should be
  a list of strings that has the same length as the number of items in the
  \code{\link{Itempool-class}} object, i.e. \code{ip$n$items}. There should
  not be any duplicated ID's. If there are \code{\link{Testlet-class}}
  objects in the item pool, the items within the testlet elements will be
  updated.
  }
  \item{\strong{\code{'id'}}}{For \code{id}, the value should be a list of
  strings that has the same length as the length of the
  \code{\link{Itempool-class}} object. There should not be any duplicated
  ID's. If there are only \code{\link{Item-class}} objects, then item ID's
  will be updated. If there are \code{\link{Testlet-class}} objects in the
  item pool, then only the testlet IDs will be updated. Items within the
  Testlet can be updated using \code{..$item_id}.
  }
  \item{\strong{\code{'content'}}}{For \code{content}, the value should be
  either \code{NULL} or a list of strings that has the same length as the
  length of the \code{\link{Itempool-class}} object.
  }
  \item{\strong{\code{'item_list'}}}{For \code{item_list}, the value should
  be a list of \code{\link{Item-class}} or \code{\link{Testlet-class}}
  objects.
  }
  \item{\strong{\code{'misc'}}}{For \code{misc}, the value should be a
  list.
  }
}}
}
\value{
This operation will return an \code{\link{Itempool-class}} object.
}
\description{
Set values to parameters or components of 'Itempool' class.
}
\examples{
ip <- generate_ip(model = "3PL", n = 5)
ip$a
# Set new values for the a parameters
ip$a <- 2
# Set new values for the b parameters
ip$b <- -2:2
# Set new ids
ip$item_id <- paste0("my-item-", 5:9)

# Set new item content
ip$content <- c("Geometry", "Algebra", "Algebra", "Geometry", "Geometry")

# Add misc field to all items:
ip$difficulty <- c("Easy", "Easy", "Hard", "Hard", "Hard")
ip$difficulty

# Add an overall misc field to itempool:
ip$form_name <- "Frm8"

# Remove the misc field from all items
ip$difficulty <- NULL
ip$difficulty

}
\author{
Emre Gonulates
}
