% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gen_isosurface}
\alias{gen_isosurface}
\title{Generate voxel coordinates defined by an implicit function}
\usage{
gen_isosurface(
  f,
  upper = 0,
  lower = -Inf,
  scale = 1,
  nx = 51,
  ny = nx,
  nz = nx
)
}
\arguments{
\item{f}{function of the form \code{f(x, y, z)} which returns a numeric value}

\item{lower, upper}{When the supplied function is evaluated, the lower and upper
limits define the range of values which will be considered to be 
inside the object. The efault [-Inf, 0] means that any value less than
or equal to zero is inside, and all positive values are outside.}

\item{scale}{extra scaling factor applied to coordinates before calling 
function}

\item{nx, ny, nz}{the dimensions of the volume within which the function 
will be evaluated}
}
\value{
data.frame of coordinates
}
\description{
Generate voxel coordinates defined by an implicit function
}
\examples{
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Create a sphere of radius 10
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
coords <- gen_isosurface(
  f = function(x, y, z) {x^2 + y^2 + z^2},
  upper = 10^2
) 

coords |>
  isocubesGrob() |> 
  grid::grid.draw()
  
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Create a complex shape
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
grid::grid.newpage()
f <- function(x, y, z) {
  (x-2)^2 * (x+2)^2 + 
  (y-2)^2 * (y+2)^2 + 
  (z-2)^2 * (z+2)^2 +
  3 * (x^2 * y^2 + x^2 * z^2 + y^2 * z^2) +
  6 * x * y * z -
  10 * (x^2 + y^2 + z^2) + 22
}

gen_isosurface(
  f = f,
  scale = 0.1,
  nx = 70
) |> 
  isocubesGrob(size = 2) |> 
  grid::grid.draw()
}
