% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{graficarFrecuenciaAlternativas}
\alias{graficarFrecuenciaAlternativas}
\title{Gráfico frecuencia alternativas}
\usage{
graficarFrecuenciaAlternativas(respuestas, alternativas, clave = NULL)
}
\arguments{
\item{respuestas}{Un data frame con las alternativas seleccionadas por los
estudiantes en cada ítem.}

\item{alternativas}{Un vector con las alternativas posibles como respuestas.}

\item{clave}{(opcional) Un data frame con las alternativas correctas para cada
ítem. Si se incluye este parámetro, se marcará la alternativa correcta en el eje x.}
}
\value{
Una lista en la que cada elemento corresponde al gráfico de cada ítem.
}
\description{
Grafica la frecuencia con que cada alternativa fue seleccionada por los
estudiantes en cada ítem.
}
\examples{
alternativas <- c(LETTERS[1:5], "*")
respuestas <- datos[,-1]
grafico <- graficarFrecuenciaAlternativas(respuestas, alternativas, clave)
grafico$i01
grafico$i025
grafico$i025

}
\seealso{
\code{\link{datos}} y \code{\link{clave}}.
}
