% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{pBis}
\alias{pBis}
\title{Correlación biserial puntual.}
\usage{
pBis(respuestas, clave, alternativas, correccionPje = TRUE, digitos = 2)
}
\arguments{
\item{respuestas}{Un data frame con las alternativas seleccionadas por los
estudiantes a cada ítem de la prueba.}

\item{clave}{Un data frame con la alternativa correcta para cada ítem.}

\item{alternativas}{Un vector con las alternativas posibles para cada ítem.}

\item{correccionPje}{Un valor lógico para usar o no la corrección de puntaje.
La corrección de puntaje consiste en restar del puntaje total el punto obtenido
por el ítem analizado.}

\item{digitos}{La cantidad de dígitos significativos que tendrá el resultado.}
}
\value{
Un data frame con la correlación biserial puntual para cada alternativa
en cada ítem.
}
\description{
Calcula la correlación biserial puntual para cada alternativa en cada ítem con
respecto al puntaje obtenido en la prueba.
}
\details{
Para su cálculo se utiliza la siguiente ecuación:
\deqn{
    r_{bp} = \frac{\overline{X_{p}}-\overline{X_{q}}}{\sigma_{X}}\sqrt{p \cdot q}
}
}
\examples{
respuestas <- datos[, -1]
alternativas <- LETTERS[1:5]
pBis(respuestas, clave, alternativas)

}
\references{
Attorresi, H, Galibert, M. y Aguerri, M. (1999). Valoración de los
ejercicios en las pruebas de rendimiento escolar. Educación Matemática. Vol. 11 No. 3, pp. 104-119.
Recuperado de \url{http://www.revista-educacion-matematica.org.mx/descargas/Vol11/3/10Attorresi.pdf}
}
\seealso{
\code{\link{analizarAlternativas}}, \code{\link{calcularFrecuenciaAlternativas}}
\code{\link{datos}} y \code{\link{clave}}.
}
