% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i_rep.R
\name{i_rep}
\alias{i_rep}
\title{Repeat values from an iterator.}
\usage{
i_rep(iterable, times = 1, length.out = NULL, each = 1, ...)
}
\arguments{
\item{iterable}{The iterable to iterate over repeatedly.}

\item{times}{How many times to recycle the underlying iteror (via
\link{i_recycle}).}

\item{length.out}{The maximum length of output. If this is given
\code{times} is ignored.}

\item{each}{The number of times to repeat each element.  You can
pass a vector (recycled), or another iterable, to repeat each
element a varying number of times.}

\item{...}{further arguments passed along to \code{iteror(iterable, ...)}}
}
\value{
an iteror yilding and repeating values from \code{iterable}.
}
\description{
An analogue of the \code{rep} function operating on iterables.
}
\details{
Note that arguments \code{times} and \code{each} can work slightly
differently from \link{rep}; \code{times} must always be of length 1; to
repeat each element a specific number of times, provide a vector to
\code{each} rather than \code{times}.

Originally from the \code{itertools} package.
}
\examples{

as.numeric(i_rep(1:4, 2))
as.numeric(i_rep(1:4, each=2))
as.numeric(i_rep(1:4, each=c(2,2,2,2)))
as.numeric(i_rep(1:4, each=c(2,1,2,1)))
as.numeric(i_rep(1:4, each=2, len=4))
as.numeric(i_rep(1:4, each=2, len=10))
as.numeric(i_rep(1:4, each=2, times=3))

# Note `rep` makes `times` behave like `each` when given a vector.
# `i_rep` does not reproduce this behavior; give the vector to `each`.
# These are equivalent:
as.numeric(i_rep(1:4, each = 1:8, times=2))
rep(rep(1:4, times=2), times=1:8)

}
\seealso{
\link[base:rep]{base::rep}, \link{i_recycle}
}
\keyword{utilities}
