% Generated by roxygen2 (4.0.1): do not edit by hand
\name{consume}
\alias{consume}
\title{Consumes the first n elements of an iterator}
\usage{
consume(iterator, n = 0)
}
\arguments{
\item{iterator}{an iterator object}

\item{n}{The number of elements to consume.}
}
\value{
Nothing, i.e., \code{invisible(NULL)}
}
\description{
Advances the iterator n-steps ahead without returning anything.
}
\details{
If \code{n} is 0, the iterator is consumed entirely. Similarly, if \code{n}
is larger than the length of the iterator, the iterator is consumed entirely.
}
\examples{
it <- iterators::iter(1:10)
# Skips the first 5 elements
consume(it, n=5)
# Returns 6
iterators::nextElem(it)

it2 <- iterators::iter(letters)
# Skips the first 4 elements
consume(it2, 4)
# Returns 'e'
iterators::nextElem(it2)
}

