% Generated by roxygen2 (4.0.1): do not edit by hand
\name{iunique_justseen}
\alias{iunique_justseen}
\title{Iterator that extracts the just-seen unique elements from an iterable object}
\usage{
iunique_justseen(object)
}
\arguments{
\item{object}{an iterable object}
}
\value{
an iterator that returns the just-seen unique elements from
\code{object}
}
\description{
Constructs an iterator that extracts each unique element in turn from an
iterable \code{object}. Order of the elements is maintained. Only the element
just seen is remembered for determining uniqueness.
}
\examples{
it <- ichain(rep(1,4), rep(2, 5), 4:7, 2)
it_iunique <- iunique_justseen(it)
as.list(it_iunique) # 1 2 4 5 6 7 2

it2 <- iterators::iter(c('a', 'a', "A", 'a', 'a', "V"))
it2_iunique <- iunique_justseen(it2)
as.list(it2_iunique) # a A a V
}

