% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{splineUpdate}
\alias{splineUpdate}
\title{Constructing higher order splines}
\usage{
splineUpdate(x, bmat, knots, i, current.order)
}
\arguments{
\item{x}{vector, the values at which to evaluate the basis
function.}

\item{bmat}{matrix. Each column of \code{bmat} corresponds to an
element of argument \code{x}. Each row corresponds to the
evaluation of basis component \code{i}, \code{i + 1}, .... The
recursive nature of splines requires that we initially evaluate
the basis functions for components \code{i}, ..., \code{i +
degree of spline}. Each iteration of the recursion reduces the
row of \code{bmat} by 1. The recursion terminates once
\code{bmat} has only a single row.}

\item{knots}{vector, the internal knots.}

\item{i}{integer, the basis component of interest.}

\item{current.order}{integer, the current order associated with the
argument \code{bmat}.}
}
\value{
vector, the evaluation of the spline at each value in
    vector \code{x}.
}
\description{
This function recursively constructs the higher order splines
basis. Note that the function does not take into consideration the
order of the final basis function. The dimensions of the inputs
dicate this, and are updated in each iteration of the
recursion. The recursion ends once the row number of argument
\code{bmat} reaches 1. This function was coded in accordance to
Carl de Boor's set of notes on splines, "B(asic)-Spline Basics".
}
