% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkewKostkaFoulkes.R
\name{SkewKostkaFoulkesPolynomial}
\alias{SkewKostkaFoulkesPolynomial}
\title{Skew Kostka-Foulkes polynomial}
\usage{
SkewKostkaFoulkesPolynomial(lambda, mu, nu)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{nu}{integer partition; the condition
\code{sum(nu)==sum(lambda)-sum(mu)} is necessary in order to get a
non-zero polynomial}
}
\value{
The skew Kostka-Foulkes polynomial associated to the skew
  partitiion defined by \code{lambda} and \code{mu} and to the partition
  \code{nu}. This is a univariate \code{qspray} polynomial whose value
  at \code{1} is the skew Kostka number associated to the skew partition
  defined by \code{lambda} and \code{mu} and to the partition \code{nu}.
}
\description{
Computes a skew Kostka-Foulkes polynomial.
}
