% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw_kmeans.R
\name{jackstraw_kmeans}
\alias{jackstraw_kmeans}
\title{Non-Parametric Jackstraw for K-means Clustering}
\usage{
jackstraw_kmeans(
  dat,
  kmeans.dat,
  s = NULL,
  B = NULL,
  center = FALSE,
  covariate = NULL,
  match = TRUE,
  pool = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{dat}{a matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{kmeans.dat}{an output from applying \code{kmeans()} onto \code{dat}.}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations.}

\item{center}{a logical specifying to center the rows of the null samples. By default, \code{TRUE}.}

\item{covariate}{a model matrix of covariates with \code{n} observations. Must include an intercept in the first column.}

\item{match}{a logical specifying to match the observed clusters and jackstraw clusters using minimum Euclidean distances.}

\item{pool}{a logical specifying to pool the null statistics across all clusters. By default, \code{TRUE}.}

\item{verbose}{a logical specifying to print the computational progress. By default, \code{FALSE}.}

\item{...}{optional arguments to control the k-means clustering algorithm (refers to \code{kmeans}).}
}
\value{
\code{jackstraw_kmeans} returns a list consisting of
\item{F.obs}{\code{m} observed F statistics between variables and cluster centers.}
\item{F.null}{F null statistics between null variables and cluster centers, from the jackstraw method.}
\item{p.F}{\code{m} p-values of membership.}
}
\description{
Test the cluster membership for K-means clustering
}
\details{
K-means clustering assign \code{m} rows into \code{K} clusters. This function enable statistical
evaluation if the cluster membership is correctly assigned. Each of \code{m} p-values refers to
the statistical test of that row with regard to its assigned cluster.
Its resampling strategy accounts for the over-fitting characteristics due to direct computation of clusters from the observed data
and protects against an anti-conservative bias.

The input data (\code{dat}) must be of a class `matrix`.
}
\examples{
\dontrun{
dat = t(scale(t(Jurkat293T), center=TRUE, scale=FALSE))
kmeans.dat <- kmeans(dat, centers=2, nstart = 10, iter.max = 100)
jackstraw.out <- jackstraw_kmeans(dat, kmeans.dat)
}

}
\references{
Chung (2020) Statistical significance of cluster membership for unsupervised evaluation of cell identities. Bioinformatics, 36(10): 3107–3114 \doi{10.1093/bioinformatics/btaa087}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
