% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_compare.R
\name{forestplot_compare}
\alias{forestplot_compare}
\title{Forest Plot Comparison for One or Two Models}
\usage{
forestplot_compare(
  model1,
  model2 = NULL,
  pars,
  pars2 = NULL,
  plotmath.labels = NULL,
  plotmath.labels2 = NULL,
  study.labels = NULL,
  consolidate.param.labels = FALSE,
  model1.name = "Model 1",
  model2.name = "Model 2",
  model.legend.title = "Model",
  ref.lines = c(0),
  colors = c("blue", "red"),
  point.size = 3,
  point.shapes = c(16, 17),
  prob = 0.5,
  prob.outer = 0.9,
  point.est = "median",
  x.lab = "Estimate",
  y.lab = NULL,
  inner.line.thickness = 1.5,
  outer.line.thickness = 0.5,
  x.lim = NULL,
  param.distance = 0.3,
  group.spacing = 1,
  flip.coords = FALSE,
  x.label.angle = 0,
  study.label.size = 11,
  ...
)
}
\arguments{
\item{model1}{First model object. Can be an `mcmc.list` object, a model with BUGS output, a matrix, or a data frame of MCMC draws.}

\item{model2}{Optional second model object. If omitted, the function can compare two parameter sets within model1.
Accepted types are the same as `model1`.}

\item{pars}{Character vector of parameter names for the first model or first parameter set}

\item{pars2}{Optional character vector of parameter names for the second parameter set in model1. Ignored if model2 is provided.}

\item{plotmath.labels}{Optional vector of plotmath expressions as strings to label parameters in the first model or set.}

\item{plotmath.labels2}{Optional vector of plotmath expressions for parameters in the second parameter set in model1.}

\item{study.labels}{Optional character vector of labels to use for studies on the y-axis. If provided,
these labels will replace parameter names, and each study label will correspond to a pair of estimates.}

\item{consolidate.param.labels}{Logical. If `TRUE` and `study.labels` is `NULL` for comparison plots,
displays a single consolidated label for the parameter pair.
If `FALSE` (default), displays a label for each individual parameter.
Ignored for single model plots.}

\item{model1.name}{Label for the first model in the plot legend.}

\item{model2.name}{Label for the second model or parameter set in the legend.}

\item{model.legend.title}{Title for the model legend.}

\item{ref.lines}{Numeric vector of vertical reference lines to display.}

\item{colors}{Vector of colors for each model or parameter set.}

\item{point.size}{Size of point estimate markers.}

\item{point.shapes}{Shapes used for points corresponding to each model or set}

\item{prob}{Width of the inner credible interval (e.g. 0.5 for 50 \% interval).}

\item{prob.outer}{Width of the outer credible interval (e.g. 0.9 for 90\% interval).}

\item{point.est}{Which point estimate to use: "median" or "mean", default is "median".}

\item{x.lab}{Label for the x-axis.}

\item{y.lab}{Label for the y-axis.}

\item{inner.line.thickness}{Thickness of inner credible interval lines.}

\item{outer.line.thickness}{Thickness of outer credible interval lines.}

\item{x.lim}{Optional numeric vector of length two to fix x-axis limits.}

\item{param.distance}{Numeric, controls the vertical distance between points for different models/parameter sets
within the same study. Default is 0.3.}

\item{group.spacing}{Numeric, controls the vertical spacing between different studies/group of parameters. Default is 1.}

\item{flip.coords}{Logical, if TRUE, flips the x and y axes, creating a horizontal plot. Default is FALSE.}

\item{x.label.angle}{Numeric. Angle for x-axis labels when `flip.coords = TRUE`. Default is 0.}

\item{study.label.size}{Numeric. Text size for study or parameter labels on the y-axis (or x-axis if flipped).}

\item{...}{\dots}
}
\description{
Creates a forest plot comparing parameter estimates from either:
- a single model with one parameter set.
- a single model with two different parameter sets.
- two different models with matching parameters.
}
