\name{ajd}
\alias{ajd}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Wrapper: Joint approximate diagonalization of a set of matrices}
\description{
This function is mainly a wrapper to the different algorithms provided in the
package. So see the help of the different algorithms for the details.
}
\usage{
ajd(M, A0 = NULL, B0 = NULL, eps = .Machine$double.eps, 
	itermax = 200, keepTrace = FALSE, methods = c("jedi"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{M}{DOUBLE ARRAY (KxKxN). Three-dimensional array with dimensions 
KxKxN representing the set
of square and real-valued matrices to be jointly diagonalized. 
N is the number of matrices. Matrices
are KxK square matrices.}
  \item{A0}{DOUBLE MATRIX (KxK). The initial guess of the inverse of a joint 
diagonalizer. If NULL, an initial
guess is automatically generated by the algorithm.}
   \item{B0}{DOUBLE MATRIX (KxK). The initial guess of a joint 
diagonalizer. If NULL, an initial
guess is automatically generated by the algorithm.}
  \item{eps}{DOUBLE. The algorithm stops when the criterion difference 
between two
iterations is less than eps.}
  \item{itermax}{INTEGER. Alternatively, the algorithm stops when itermax 
sweeps have
been performed without reaching convergence. If the maximum number of
iteration is performed, a warning appears.}
  \item{keepTrace}{BOOLEAN. Do we want to keep the successive estimations of 
the joint diagonalizer.}
  \item{methods}{STRING. One or more methods, choosen among the set of available
algorithms. Possible values are: jedi, ffdiag, jadiag, uwedge, qdiag}
}
\details{
	This function is mainly a wrapper to use the different algorithms provided
	in the package (see help of the different functions).
}
\value{
	If the number of methods is one, the result is the structure provided by
		the algorithm used.
	
	If the number of methods is more than one, a list of results provided by
	each algorithm is given. Names of the list correspond to methods.
}
\author{Cedric Gouy-Pailler (cedric.gouypailler@gmail.com)} 
\examples{
# generating diagonal matrices
D <- replicate(30, diag(rchisq(df=1,n=10)), simplify=FALSE)
# Mixing and demixing matrices
B <- matrix(rnorm(100),10,10)
A <- solve(B)
C <- array(NA,dim=c(10,10,30))
for (i in 1:30) C[,,i] <- A \%*\% D[[i]] \%*\% t(A)
ajd(C,method=c("jedi","ffdiag"))
}
\keyword{algebra}




