% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_post_jointVIP.R
\name{create_post_jointVIP}
\alias{create_post_jointVIP}
\title{create post_jointVIP object}
\usage{
create_post_jointVIP(object, post_analysis_df, wts = NA)
}
\arguments{
\item{object}{a jointVIP object}

\item{post_analysis_df}{post matched or weighted data.frame}

\item{wts}{user-supplied weights}
}
\value{
a post_jointVIP object (subclass of jointVIP)
}
\description{
This is creates the post_jointVIP object & check inputs
}
\examples{
data <- data.frame(year = rnorm(50, 200, 5),
                   pop = rnorm(50, 1000, 500),
                   gdpPercap = runif(50, 100, 1000),
                   trt = rbinom(50, 1, 0.5),
                   out = rnorm(50, 1, 0.2))
# random 20 percent of control as pilot data
pilot_sample_num = sample(which(data$trt == 0),
                          length(which(data$trt == 0)) *
                          0.2)
pilot_df = data[pilot_sample_num, ]
analysis_df = data[-pilot_sample_num, ]
treatment = "trt"
outcome = "out"
covariates = names(analysis_df)[!names(analysis_df)
                                \%in\% c(treatment, outcome)]
new_jointVIP = create_jointVIP(treatment = treatment,
                               outcome = outcome,
                               covariates = covariates,
                               pilot_df = pilot_df,
                               analysis_df = analysis_df)

## at this step typically you may wish to do matching or weighting
## the results after can be stored as a post_data
## the post_data here is not matched or weighted, only for illustrative purposes
post_data <- data.frame(year = rnorm(50, 200, 5),
                        pop = rnorm(50, 1000, 500),
                        gdpPercap = runif(50, 100, 1000),
                        trt = rbinom(50, 1, 0.5),
                        out = rnorm(50, 1, 0.2))
post_dat_jointVIP =  create_post_jointVIP(new_jointVIP, post_data)
}
