% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Chisq.R
\name{Chisq}
\alias{Chisq}
\alias{d,Chisq,numeric-method}
\alias{p,Chisq,numeric-method}
\alias{qn,Chisq,numeric-method}
\alias{r,Chisq,numeric-method}
\alias{mean,Chisq-method}
\alias{median,Chisq-method}
\alias{mode,Chisq-method}
\alias{var,Chisq-method}
\alias{sd,Chisq-method}
\alias{skew,Chisq-method}
\alias{kurt,Chisq-method}
\alias{entro,Chisq-method}
\alias{finf,Chisq-method}
\alias{llchisq}
\alias{ll,Chisq,numeric-method}
\alias{echisq}
\alias{mle,Chisq,numeric-method}
\alias{me,Chisq,numeric-method}
\alias{vchisq}
\alias{avar_mle,Chisq-method}
\alias{avar_me,Chisq-method}
\title{Chi-Square Distribution}
\usage{
Chisq(df = 1)

\S4method{d}{Chisq,numeric}(distr, x, log = FALSE)

\S4method{p}{Chisq,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Chisq,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Chisq,numeric}(distr, n)

\S4method{mean}{Chisq}(x)

\S4method{median}{Chisq}(x)

\S4method{mode}{Chisq}(x)

\S4method{var}{Chisq}(x)

\S4method{sd}{Chisq}(x)

\S4method{skew}{Chisq}(x)

\S4method{kurt}{Chisq}(x)

\S4method{entro}{Chisq}(x)

\S4method{finf}{Chisq}(x)

llchisq(x, df)

\S4method{ll}{Chisq,numeric}(distr, x)

echisq(x, type = "mle", ...)

\S4method{mle}{Chisq,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Chisq,numeric}(distr, x, na.rm = FALSE)

vchisq(df, type = "mle")

\S4method{avar_mle}{Chisq}(distr)

\S4method{avar_me}{Chisq}(distr)
}
\arguments{
\item{df}{numeric. The distribution degrees of freedom parameter.}

\item{distr}{an object of class \code{Chisq}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Chisq}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Chi-Square distribution is a continuous probability distribution commonly
used in statistical inference, particularly in hypothesis testing and
confidence interval estimation. It is defined by the degrees of freedom
parameter \eqn{k > 0}.
}
\details{
The probability density function (PDF) of the Chi-Square distribution is
given by: \deqn{ f(x; k) = \frac{1}{2^{k/2}\Gamma(k/2)} x^{k/2 - 1} e^{-x/2},
\quad x > 0.}
}
\examples{
# -----------------------------------------------------
# Chi-Square Distribution Example
# -----------------------------------------------------

# Create the distribution
df <- 4
D <- Chisq(df)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 20)) # density function
p(D, c(0.3, 2, 20)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
den <- d(D) ; den(x) # den is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llchisq(x, df)

echisq(x, type = "mle")
echisq(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("chisq", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vchisq(df, type = "mle")
vchisq(df, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dchisq]{dchisq()}}, \code{\link[=pchisq]{pchisq()}}, \code{\link[=qchisq]{qchisq()}},
\code{\link[=rchisq]{rchisq()}}
}
