% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Multinom.R
\name{Multinom}
\alias{Multinom}
\alias{d,Multinom,numeric-method}
\alias{r,Multinom,numeric-method}
\alias{mean,Multinom-method}
\alias{mode,Multinom-method}
\alias{var,Multinom-method}
\alias{entro,Multinom-method}
\alias{finf,Multinom-method}
\alias{llmultinom}
\alias{ll,Multinom,matrix-method}
\alias{emultinom}
\alias{mle,Multinom,matrix-method}
\alias{me,Multinom,matrix-method}
\alias{vmultinom}
\alias{avar_mle,Multinom-method}
\alias{avar_me,Multinom-method}
\title{Multinomial Distribution}
\usage{
Multinom(size = 1, prob = c(0.5, 0.5))

\S4method{d}{Multinom,numeric}(distr, x, log = FALSE)

\S4method{r}{Multinom,numeric}(distr, n)

\S4method{mean}{Multinom}(x)

\S4method{mode}{Multinom}(x)

\S4method{var}{Multinom}(x)

\S4method{entro}{Multinom}(x)

\S4method{finf}{Multinom}(x)

llmultinom(x, size, prob)

\S4method{ll}{Multinom,matrix}(distr, x)

emultinom(x, type = "mle", ...)

\S4method{mle}{Multinom,matrix}(distr, x, na.rm = FALSE)

\S4method{me}{Multinom,matrix}(distr, x, na.rm = FALSE)

vmultinom(size, prob, type = "mle")

\S4method{avar_mle}{Multinom}(distr)

\S4method{avar_me}{Multinom}(distr)
}
\arguments{
\item{size}{number of trials (zero or more).}

\item{prob}{numeric. Probability of success on each trial.}

\item{distr}{an object of class \code{Multinom}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Multinom}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log}{logical. Should the logarithm of the probability be
returned?}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The multinomial distribution is a discrete probability distribution which
models the probability of having x successes in n independent categorical
trials with success probability vector p.
}
\details{
The probability mass function (PMF) of the Multinomial distribution is:
\deqn{ P(X_1 = x_1, ..., X_k = x_k) = \frac{n!}{x_1! x_2! ... x_k!}
\prod_{i=1}^k p_i^{x_i}, }
subject to \eqn{ \sum_{i=1}^{k} x_i = n }.
}
\examples{
# -----------------------------------------------------
# Multinomial Distribution Example
# -----------------------------------------------------

# Create the distribution
N <- 10 ; p <- c(0.1, 0.2, 0.7)
D <- Multinom(N, p)

# ------------------
# dpqr Functions
# ------------------

d(D, c(2, 3, 5)) # density function

# alternative way to use the function
df <- d(D) ; df(c(2, 3, 5)) # df is a function itself

x <- r(D, 100) # random generator function

# ------------------
# Moments
# ------------------

mean(D) # Expectation
mode(D) # Mode
var(D) # Variance
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llmultinom(x, N, p)

emultinom(x, type = "mle")
emultinom(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("multinom", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vmultinom(N, p, type = "mle")
vmultinom(N, p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dmultinom]{dmultinom()}}, \code{\link[=rmultinom]{rmultinom()}}
}
