% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_calculus.R
\name{calculus}
\alias{calculus}
\alias{+,Norm,Norm-method}
\alias{+,numeric,Norm-method}
\alias{+,Norm,numeric-method}
\alias{-,Norm,Norm-method}
\alias{-,numeric,Norm-method}
\alias{-,Norm,numeric-method}
\alias{*,numeric,Norm-method}
\alias{*,Norm,numeric-method}
\alias{/,Norm,numeric-method}
\alias{sum,Norm,logical-method}
\alias{exp,Norm-method}
\title{Distributional Calculus}
\usage{
\S4method{+}{Norm,Norm}(e1, e2)

\S4method{+}{numeric,Norm}(e1, e2)

\S4method{+}{Norm,numeric}(e1, e2)

\S4method{-}{Norm,Norm}(e1, e2)

\S4method{-}{numeric,Norm}(e1, e2)

\S4method{-}{Norm,numeric}(e1, e2)

\S4method{*}{numeric,Norm}(e1, e2)

\S4method{*}{Norm,numeric}(e1, e2)

\S4method{/}{Norm,numeric}(e1, e2)

\S4method{sum}{Norm,logical}(x, ..., na.rm = FALSE)

\S4method{exp}{Norm}(x)
}
\arguments{
\item{x, e1, e2}{objects of subclass \code{Distribution}.}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
All calculations return \code{Distribution} objects (specifically, objects
of a class that is a subclass of \code{Distribution}), according to the property
at hand.
}
\description{
Arithmetic operators and functions for probability distribution objects.
These methods define how standard operations like \code{+}, \code{-},
\code{*}, and \code{/} behave when applied to random variables, returning the
resulting distribution based on known properties of common distribution
families.
}
\examples{
# -----------------------------------------------------
# Distribution Calculus Example
# -----------------------------------------------------

# Normal location - scale transformation
x <- Norm(2, 3)
y <- 3 * x + 1 # Norm(7, 9)

# Addition of two independent Normal random variables
x1 <- Norm(1, 3)
x2 <- Norm(2, 4)
x3 <- x1 + x2 # Norm(3, 5)
}
