% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jstage_references.R
\name{jstage_references}
\alias{jstage_references}
\title{Scrape J-STAGE References}
\usage{
jstage_references(url, depth = 1, citedby = FALSE, wait = 1, quiet = TRUE)
}
\arguments{
\item{url}{The URL or DOI of the J-STAGE article web page.}

\item{depth}{Integer. The depth to which references should be scraped. For example, a
depth of 2 means the references of the specified paper and recursively the
references of those references are scraped, and so on.}

\item{citedby}{Logical. Set to \code{TRUE} to retrieve the list of cited-by references instead
of the reference list. When set to \code{TRUE}, \code{depth} is automatically set to
1.}

\item{wait}{Numeric. The number of seconds to wait between each request to reduce
server load.}

\item{quiet}{Logical. Set to \code{FALSE} to display information about the progress.}
}
\value{
A data frame with the DOI of each reference.
}
\description{
Scrapes all available references from a J-STAGE article web page.
}
