% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpfj.R
\name{auto_hpfj}
\alias{auto_hpfj}
\title{Automatic selection of the optimal HP filter with jumps}
\usage{
auto_hpfj(
  y,
  grid = seq(0, sd(y, na.rm = TRUE) * 10, sd(y, na.rm = TRUE)/10),
  ic = c("bic", "hq", "aic", "aicc"),
  edf = TRUE
)
}
\arguments{
\item{y}{numeric vector cotaining the time series;}

\item{grid}{numeric vector containing the grid for the argument \code{maxsum}
of the \code{hpfj} function;}

\item{ic}{string with information criterion for the choice: the default is
"bic" (simulations show this is the best choice), but also "hq", "aic" and "aicc"
are available;}

\item{edf}{logical scalar: TRUE (default) if the number of degrees of freedom
should be computed as "effective degrees of freedom" (Efron, 1986) as opposed
to a more traditional way (although not supported by theory) when FALSE.}
}
\value{
The same ouput as the \code{hpjf} function corresponding to the best
choice according to the selected information criterion.
}
\description{
The regularization constant for the HP filter with jumps is the
maximal sum of standard deviations for the level disturbance. This value
has to be passed to the \code{hpfj} function. The \code{auto_hpfj} runs
\code{hpfj} on a grid of regularization constants and returns the output
of \code{hpfj} selected by the chosen information criterion.
}
\examples{
mod <- auto_hpfj(Nile)
plot(as.numeric(Nile))
lines(mod$smoothed_level)

}
