% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{llt}
\alias{llt}
\title{Kalman filtering and smoothing for local linear trend plus noise}
\usage{
llt(
  y,
  var_eps,
  var_eta,
  var_zeta,
  cov_eta_zeta,
  a1,
  a2,
  p11,
  p12,
  p22,
  k1,
  k2,
  i,
  f,
  r1,
  r2,
  n11,
  n12,
  n22,
  e,
  d,
  w_ = NULL
)
}
\arguments{
\item{y}{vector of n observations}

\item{var_eps}{vector of n variances for the observation noises}

\item{var_eta}{vector of n variances for the level disturbances}

\item{var_zeta}{vector of n variances for the slope disturbances}

\item{cov_eta_zeta}{vector of n covariances between level and slope disturbances}

\item{a1}{vector of n+1 one-step-ahead prediction of the level; the first
element is the initial condition for the level at time t=1, the other elements
are arbitrary and will be overwritten}

\item{a2}{vector of n+1 one-step-ahead prediction of the slope; the first
element is the initial condition for the slope at time t=1, the other elements
are arbitrary and will be overwritten}

\item{p11}{vector of n+1 one-step-ahead prediction error variance of the level;
the first element is the initial condition for the level at time t=1, the other elements
are arbitrary and will be overwritten}

\item{p12}{vector of n+1 one-step-ahead prediction covariances for level and slope;
the first element is the initial condition for the slope at time t=1, the other elements
are arbitrary and will be overwritten}

\item{p22}{vector of n+1 one-step-ahead prediction error variance of the slope;
the first element is the initial condition for the level at time t=1, the other elements
are arbitrary and will be overwritten}

\item{k1}{vector of the n Kalman gains for the level equation; values are
arbitrary and will be overwritten;}

\item{k2}{vector of the n Kalman gains for the slope equation; values are
arbitrary and will be overwritten;}

\item{i}{vector of the n innovations; values are
arbitrary and will be overwritten;}

\item{f}{vector of the n innovatoin variances;values are
arbitrary and will be overwritten;}

\item{r1}{vector of the n+1 smoothers (Th.5.4 in Pelagatti, 2015)
for the level equation; values are arbitrary and will be overwritten;}

\item{r2}{vector of the n+1 smoothers (Th.5.4 in Pelagatti, 2015) for
the slope equation; values are arbitrary and will be overwritten;}

\item{n11}{vector of the n+1 variance smoothers (Th.5.4 in Pelagatti, 2015) for the level
equation; values are arbitrary and will be overwritten;}

\item{n12}{vector of the n+1 covariance smoothers (Th.5.4 in Pelagatti, 2015) for the level
and slope; values are arbitrary and will be overwritten;}

\item{n22}{vector of the n+1 variance smoothers (Th.5.4 in Pelagatti, 2015) for the slope
equation; values are arbitrary and will be overwritten;}

\item{e}{vector of the n+1 observation error smoothers (Th.5.4 in Pelagatti, 2015);
values are arbitrary and will be overwritten;}

\item{d}{vector of the n+1 observation error variance smoothers (Th.5.4 in Pelagatti, 2015);
values are arbitrary and will be overwritten;}

\item{w_}{NULL (default) or vector of n weights for the effect of observation y_t
on the estimation of the hp filter (with jumps) at time t;
values are arbitrary and will be overwritten;}
}
\value{
The value of the Gaussian log-likelihood net of the -log(2*pi)*n/2 part
that can be added if needed.
}
\description{
It uses the power of C++, scalar computation and pointers
to run the Kalman filter, the smoother and compute the log-likelihood.
The R user has to supply many vectors that in most cases will be
overwritten by the llt() function since they are passed by reference.
All passed parameters must be numerical (floating point) vectors:
any other kind of variable may cause serious problems to the stability
of your system. Passing vectors of integers will make the computations fail.
}
