% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_adaptive.R
\name{kade}
\alias{kade}
\title{Kernel Adaptive Density Estimator}
\usage{
kade(x, data, kernel = c("gaussian", "epanechnikov", "rectangular"),
  method = c("both", "ranktrafo", "nonrobust"), Sigma = seq(0.01, 10, length
  = 51), h = NULL, theta = NULL, ranktrafo = J2, ticker = FALSE,
  plot = FALSE, parlist = NULL, ...)
}
\arguments{
\item{x}{Vector of location(s) at which the density estimate is
to be computed.}

\item{data}{Vector \eqn{(X_1, \ldots, X_n)} of the data from which the
estimate is to be computed. \code{NA}s or infinite values are
removed (and a warning is issued).}

\item{kernel}{A character string naming the kernel to be used for the
adaptive estimator. This must partially match one of
"gaussian", "rectangular" or "epanechnikov", with default
"gaussian", and may be abbreviated to a unique prefix.
(Currently, this kernel is also used for the initial,
non-adaptive Parzen-Rosenblatt estimator which enters
into the estimators of bias and variance as described in the
references.)}

\item{method}{A character string naming the method to be used for the
adaptive estimator. This must partially match one of
"both", "ranktrafo" or "nonrobust", with default "both",
and may be abbreviated to a unique prefix.}

\item{Sigma}{Vector of value(s) of the scale parameter \eqn{\sigma}.
If of length 1 no adaptation is performed. Otherwise
considered as the initial grid over which the optimization
of the adaptive method will be performed. Defaults to
\code{seq(0.01, 10, length = 51)}.}

\item{h}{Numeric scalar for bandwidth \eqn{h}. Defaults to NULL and is then
internally set to \eqn{n^{-1/5}}.}

\item{theta}{Numeric scalar for value of location parameter \eqn{\theta}.
Defaults to NULL and is then internally set to the arithmetic
mean of \eqn{x_1, \ldots, x_n}.}

\item{ranktrafo}{Function used for the rank transformation. Defaults to
\code{\link{J2}} (with its default \code{cc = sqrt(5))}.}

\item{ticker}{Logical; determines if a 'ticker' documents the iteration
progress through \code{Sigma}. Defaults to FALSE.}

\item{plot}{Logical or character or numeric and indicates if graphical
output should be produced. Defaults to FALSE (i.e., no
graphical output is produced) and is passed to
\code{\link{adaptive_fnhat}()} which does the actual work. For
details on how it is processed see there.}

\item{parlist}{A list of graphical parameters that is passed to
\code{\link{adaptive_fnhat}()}; see there. Default:
\code{NULL}.}

\item{\ldots}{Further arguments possibly passed down. Currently ignored.}
}
\value{
In the case of only one method a data frame whose components
 have the following names and meanings:
 \tabular{ll}{
  \code{x} \tab {x_0}. \cr
  \code{y} \tab Estimate of f(x_0). \cr
  \code{sigma.adap} \tab The found minimizer of the MSE-estimator, i.e.,
                         the adaptive smoothing parameter value. \cr
  \code{msehat.min} \tab The found minimum of the MSE-estimator. \cr
  \code{discr.min.smaller} \tab TRUE iff the numerically found minimum
                                was smaller than the discrete one. \cr
  \code{sig.range.adj} \tab Number of adjustments of sigma-range. \cr
  }

  In the case of both methods a list of two data frames of the
  just described structure.
}
\description{
Wrapper function which does some preparatory calculations and then calls
the actual ``workhorse'' functions which do the main computations for
kernel adaptive density estimation of Srihera & Stute (2011) or Eichner
& Stute (2013). Finally, it structures and returns the obtained results.
Summarizing information and technical details can be found in Eichner
(2017).
}
\examples{
require(stats)

 # Generating N(0,1)-data
set.seed(2017);     n <- 80;     d <- rnorm(n)

 # Estimating f(x0) for one sigma-value
x0 <- 1
(fit <- kade(x = x0, data = d, method = "nonrobust", Sigma = 1))
\donttest{
 # Estimating f(x0) for sigma-grid
x0 <- 1
(fit <- kade(x = x0, data = d, method = "nonrobust",
  Sigma = seq(0.01, 10, length = 10), ticker = TRUE))
}
\dontrun{
 # Estimating f(x0) for sigma-grid and Old-Faithful-eruptions-data
x0 <- 2
(fit <- kade(x = x0, data = faithful$eruptions, method = "nonrobust",
  Sigma = seq(0.01, 10, length = 51), ticker = TRUE, plot = TRUE))
}
}
\references{
Srihera & Stute (2011), Eichner & Stute (2013), and Eichner
            (2017): see \code{\link{kader}}.
}
