% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jfunctions.R
\name{pc}
\alias{pc}
\title{pc}
\usage{
pc(cc)
}
\arguments{
\item{cc}{Numeric vector.}
}
\value{
Vector of same length and mode as \code{cc}.
}
\description{
Coefficient \eqn{p_c} of eq. (15.15) in Eichner (2017).
}
\details{
p_c = 1/5 * (3c^2 - 5) / (3 - c^2) * c^2.

For further details see p. 297 f. in Eichner (2017) and/or Eichner & Stute
(2013).
}
\note{
\eqn{p_c} should be undefined for \eqn{c = \sqrt 3}, but \code{pc}
      is here implemented to return \code{Inf} in each element of its
      return vector for which the corresponding element in \code{cc}
      contains R's value of \code{sqrt(3)}.
}
\examples{
\donttest{
c0 <- expression(sqrt(5/3))
c1 <- expression(sqrt(3) - 0.01)
cgrid <- seq(1.325, 1.7, by = 0.025)
cvals <- c(eval(c0), cgrid, eval(c1))

plot(cvals, pc(cvals), xaxt = "n", xlab = "c", ylab = expression(p[c]))
axis(1, at = cvals, labels = c(c0, cgrid, c1), las = 2)
}

}
