% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/jackknife.R
\docType{methods}
\name{jackknife.EventDate}
\alias{jackknife.EventDate}
\alias{jackknife,EventDate-method}
\title{Jackknife Event Dates}
\usage{
\S4method{jackknife}{EventDate}(
  object,
  level = 0.95,
  calendar = get_calendar(),
  progress = getOption("kairos.progress"),
  verbose = getOption("kairos.verbose"),
  ...
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventDate}} object (typically returned by \code{\link[=event]{event()}}).}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}

\item{...}{Further arguments to be passed to internal methods.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Generates jackknife estimations of an \link[=event]{event date}.
}
\details{
One type/fabric is removed at a time and all statistics are recalculated.
In this way, one can assess whether certain type/fabric has a substantial
influence on the date estimate.

A three columns \code{data.frame} is returned, giving the results of the
resampling procedure (jackknifing fabrics) for each assemblage (in rows)
with the following columns:
\describe{
\item{\code{mean}}{The jackknife mean (event date).}
\item{\code{lower}}{The lower boundary of the confidence interval.}
\item{\code{upper}}{The upper boundary of the confidence interval.}
}
}
\seealso{
\code{\link[=event]{event()}}

Other resampling methods: 
\code{\link{bootstrap.EventDate}},
\code{\link{bootstrap.MeanDate}},
\code{\link{jackknife.MeanDate}}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
