% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{psst}
\alias{psst}
\title{PSS t Bound test}
\usage{
psst(model, case = 3, signif_level = "auto")
}
\arguments{
\item{model}{The kardl obejct}

\item{case}{Numeric or character. Specifies the case of the test to be used in the function.
Acceptable values are 1, 2, 3, 4, 5, and "auto". If "auto" is chosen, the function determines the case automatically based on the model's characteristics. Invalid values will result in an error.
\itemize{
\item \code{1}: No intercept and no trend
\item \code{2}: Restricted intercept and no trend
\item \code{3}: Unrestricted intercept and no trend
\item \code{4}: Unrestricted intercept and restricted trend
\item \code{5}: Unrestricted intercept and unrestricted trend
}}

\item{signif_level}{Character or numeric. Specifies the significance level to be used in the function.
Acceptable values are "auto", "0.10", "0.1", "0.05", "0.025", and "0.01".
If a numeric value is provided, it will be converted to a character string.
If "auto" is chosen, the function determines the significance level automatically.
Invalid values will result in an error.}
}
\value{
A list containing the results of the PSS t Bound test, including:
 \itemize{
 \item \code{type}: The type of test performed, which is "cointegration".
 \item \code{case}: The case number used in the test (1, 2, 3, 4, or 5).
 \item \code{statistic}: The t-statistic value calculated from the test.
 \item \code{k}: The number of long-run variables in the model.
 \item \code{Cont}: The conclusion of the test, indicating whether cointegration is present, inconclusive, or absent.
 \item \code{BoundNum}: A numeric representation of the conclusion, where 1 indicates cointegration, 0 indicates inconclusive, and -1 indicates no cointegration.
 \item \code{siglvl}: The significance level used in the test, either "auto" or one of the specified numeric levels.
 \item \code{criticalValues}: A vector of critical values for the test, corresponding to the significance levels.
 \item \code{parameter}: The names of the long-run variables in the model.
 \item \code{FH0}: The null hypothesis of the test, which includes the long-run variables set to zero.
 \item \code{Fmodel}: The linear hypothesis model used in the test.
 \item \code{warnings}: Any warnings generated during the test, such as sample size concerns.
 \item \code{method}: The method used for the test, which is "Narayan".
 }
}
\description{
This function performs the Pesaran t Bound test
}
\details{
This function performs the Pesaran, Shin, and Smith (PSS) t Bound test, which is used to detect the existence of a long-term relationship (cointegration) between variables in an autoregressive distributed lag (ARDL) model. The t Bound test specifically focuses on the significance of the coefficient of the lagged dependent variable, helping to assess whether the variable reverts to its long-term equilibrium after short-term deviations. The test provides critical values for both upper and lower bounds. If the t-statistic falls within the appropriate range, it confirms the presence of cointegration. This test is particularly useful when working with datasets containing both stationary and non-stationary variables.
}
\section{Hypothesis testing}{

The PSS t Bound test evaluates the null hypothesis that the long-run coefficients of the model are equal to zero against the alternative hypothesis that at least one of them is non-zero. The test is conducted under different cases, depending on the model specification.


 \deqn{
  \Delta {y}_t =  \psi  + \varphi t  + \eta _0   {y}_{t-1}  + \sum_{i=1}^{k} {  \eta _i   {x}_{i,t-1} }  +   \sum_{j=1}^{p} { \gamma_{j}  \Delta {y}_{t-j} }+ \sum_{i=1}^{k} {\sum_{j=0}^{q_i} { \beta_{ij}   \Delta {x}_{i,t-j} } }+ e_t
}

  \deqn{\mathbf{H_{0}:} \eta_0   = 0}
  \deqn{\mathbf{H_{1}:} \eta_{0}  \neq 0}
}

\examples{

kardl_model<-kardl(imf_example_data,
                    CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                    mode=c(1,2,3,0))
A<- psst(kardl_model)
cat(paste0("The t statistics=",A$statistic," where k=",A$k,"."))
 cat(paste0("\nWe found '",A$Cont, "' at ",A$siglvl,"."))


# Using magrittr

library(magrittr)
imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                    mode=c(1,2,3,0)) \%>\% psst()

# critical Values are
A$criticalValues

# Getting details of the test.
mySummary<-summary(A)
mySummary

# The null hypothesis :
mySummary$H0

imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                    mode=c(1,2,3,0)) \%>\% psst() \%>\% summary()

}
\references{
Pesaran, M. H., Shin, Y. and Smith, R. (2001), “Bounds Testing Approaches to the Analysis of Level Relationship”, Journal of Applied Econometrics, 16(3), 289-326.
}
\seealso{
\code{\link{pssf}}   \code{\link{banerjee}}  \code{\link{recmt}}  \code{\link{narayan}}
}
