% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-constructor.r
\name{shaq}
\alias{shaq}
\alias{shaq.matrix}
\alias{shaq.numeric}
\title{shaq}
\usage{
shaq(Data, nrows, ncols, checks = TRUE)

\method{shaq}{matrix}(Data, nrows, ncols, checks = TRUE)

\method{shaq}{numeric}(Data, nrows, ncols, checks = TRUE)
}
\arguments{
\item{Data}{The local submatrix.}

\item{nrows, ncols}{The GLOBAL number of rows and columns.}

\item{checks}{Logical. Should some basic dimension checks be performed?  Note that these
require communication, and with many MPI ranks, could be expensive.}
}
\description{
Constructor for shaq objects.
}
\details{
If \code{nrows} and/or \code{ncols} is missing, then it will be imputed.
This means one must be especially careful to manually provide \code{ncols}
if some of ranks have "placeholder data" (a 0x0 matrix), which is typical
when reading from a subset of processors and then broadcasting out to the
remainder.
}
\section{Communication}{

If \code{checks=TRUE}, a check on the global number of rows is performed.
This amounts to an allgather operation on a logical value (the local
dimension check).
}

\seealso{
\code{\link{shaq-class}}
}
