% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kcmeans.R
\name{predict.kcmeans}
\alias{predict.kcmeans}
\title{Prediction Method for the K-Conditional-Means Estimator.}
\usage{
\method{predict}{kcmeans}(object, newdata, clusters = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{kcmeans}.}

\item{newdata}{A (sparse) feature matrix where the first column corresponds
to the categorical predictor.}

\item{clusters}{A boolean indicating whether estimated clusters should be
returned.}

\item{...}{Currently unused.}
}
\value{
A numerical vector with predicted values (if \code{clusters = FALSE})
or predicted clusters (if \code{clusters = FALSE}).
}
\description{
Prediction method for the K-Conditional-Means estimator.
}
\examples{
# Simulate simple dataset with n=800 observations
X <- rnorm(800) # continuous predictor
Z <- sample(1:20, 800, replace = TRUE) # categorical predictor
Z0 <- Z \%\% 4 # lower-dimensional latent categorical variable
y <- Z0 + X + rnorm(800) # outcome
# Compute kcmeans with four support points
kcmeans_fit <- kcmeans(y, cbind(Z, X), K = 4)
# Calculate in-sample predictions
fitted_values <- predict(kcmeans_fit, cbind(Z, X))
# Print sample share of estimated clusters
clusters <- predict(kcmeans_fit, cbind(Z, X), clusters = TRUE)
table(clusters)
}
\references{
Wiemann T (2023). "Optimal Categorical Instruments." \url{https://arxiv.org/abs/2311.17021}
}
