% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_sequential_fit.R
\name{generic_sequential_fit}
\alias{generic_sequential_fit}
\title{Internal Fitting Engine for Sequential API Models}
\usage{
generic_sequential_fit(formula, data, layer_blocks, ...)
}
\arguments{
\item{formula}{A formula specifying the predictor and outcome variables,
passed down from the \code{parsnip::fit()} call.}

\item{data}{A data frame containing the training data, passed down from the
\code{parsnip::fit()} call.}

\item{layer_blocks}{A named list of layer block functions. This is passed
internally from the \code{parsnip} model specification.}

\item{...}{Additional arguments passed down from the model specification. These
can include:
\itemize{
\item \strong{Layer Parameters:} Arguments for the layer blocks, prefixed
with the block name (e.g., \code{dense_units = 64}).
\item \strong{Architecture Parameters:} Arguments to control the number of
times a block is repeated, in the format \verb{num_\{block_name\}} (e.g.,
\code{num_dense = 2}).
\item \strong{Compile Parameters:} Arguments to customize model compilation,
prefixed with \code{compile_} (e.g., \code{compile_loss = "mae"},
\code{compile_optimizer = "sgd"}).
\item \strong{Fit Parameters:} Arguments to customize model fitting,
prefixed with \code{fit_} (e.g., \code{fit_callbacks = list(...)},
\code{fit_class_weight = list(...)}).
}}
}
\value{
A list containing the fitted model and other metadata. This list is
stored in the \code{fit} slot of the \code{parsnip} model fit object. The list
contains the following elements:
\itemize{
\item \code{fit}: The raw, fitted Keras model object.
\item \code{history}: The Keras training history object.
\item \code{lvl}: A character vector of the outcome factor levels (for
classification) or \code{NULL} (for regression).
}
}
\description{
This function serves as the internal engine for fitting \code{kerasnip} models that
are based on the Keras sequential API. It is not intended to be called
directly by the user. The function is invoked by \code{parsnip::fit()} when a
\code{kerasnip} sequential model specification is used.
}
\details{
Generic Fitting Function for Sequential Keras Models

The function orchestrates the three main steps of the model fitting process:
\enumerate{
\item \strong{Build and Compile:} It calls
\code{build_and_compile_sequential_model()} to construct the Keras model
architecture based on the provided \code{layer_blocks} and hyperparameters.
\item \strong{Process Data:} It preprocesses the input (\code{x}) and output (\code{y})
data into the format expected by Keras.
\item \strong{Fit Model:} It calls \code{keras3::fit()} with the compiled model
and processed data, passing along any fitting-specific arguments (e.g.,
\code{epochs}, \code{batch_size}, \code{callbacks}).
}
}
\examples{
# This function is not called directly by users.
# It is called internally by `parsnip::fit()`.
# For example:
\donttest{
library(parsnip)
# create_keras_sequential_spec(...) defines my_sequential_model

# spec <- my_sequential_model(hidden_1_units = 128, fit_epochs = 10) |>
#   set_engine("keras")

# # This call to fit() would invoke generic_sequential_fit() internally
# fitted_model <- fit(spec, y ~ x, data = training_data)
}
}
\keyword{internal}
