% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_optimal.r
\name{discrete_optimal}
\alias{discrete_optimal}
\title{Discrete optimal kernel}
\usage{
discrete_optimal(x, z, h, k)
}
\arguments{
\item{x}{the target point at which the density is calculated}

\item{z}{the vector of observations}

\item{h}{the bandwidth (or smoothing parameter), which should match the
condition (3 / 5) * (1 - 1 / k)) < h < 1}

\item{k}{the integer (positive) parameter that defined the support of
the kernel function}
}
\value{
Returns the value of the associated kernel function according to
the target x and the bandwidth h.
}
\description{
Discrete optimal kernel
}
\examples{
discrete_optimal(x = 25, z = 1:50, h = 0.9, k = 20)

}
