% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens.par.temp.R
\name{dens.par.temp}
\alias{dens.par.temp}
\title{Adaptive kernel estimate of intensity of a temporal point pattern}
\usage{
dens.par.temp(
  t,
  dimt = 128,
  bw.t = NULL,
  ngroups.t = NULL,
  at = c("bins", "points")
)
}
\arguments{
\item{t}{Temporal point pattern, a vector with observations.}

\item{dimt}{Bin vector dimension. The default is 128.}

\item{bw.t}{Numeric vector of smoothing bandwidths for each point in t. The default is to compute bandwidths using \link{bw.abram.temp}.}

\item{ngroups.t}{Number of groups into which the bandwidths should be partitioned and discretised. The default is the square root (rounded) of the number of points of \code{t}.}

\item{at}{String specifying whether to estimate the intensity at bins points (\code{at = "bins"}) or only at the points of t (\code{at = "points"}).}
}
\value{
If \code{at = "points"} (the default), the result is a numeric vector with one entry for each data point in \code{t}. If \code{at = "bins"} the result is a data.frame containing the \eqn{x,y} coordinates of the intensity function.
}
\description{
Estimates the intensity of a point process with only temporal dimension by applying an adaptive (variable bandwidth) Gaussian edge-corrected kernel smoothing.
}
\details{
This function computes a temporally-adaptive kernel estimate of the intensity from a one-dimensional point pattern t using the partitioning technique of Davies and Baddeley (2018).
The argument bw.t specifies the smoothing bandwidths to be applied to each of the points in X. It should be a numeric vector of bandwidths.
Let the points of \eqn{t} be \eqn{t_1, ..., t_n} and the corresponding bandwidths \eqn{\sigma_1,...,\sigma_n}, then the adaptive kernel estimate of intensity at a location \eqn{v} is
\deqn{\lambda(v) = \sum_{i=1}^n \frac{K(v,t_i; \sigma_i)}{c(t; \sigma_i)}}
where \eqn{K()} is the Gaussian smoothing kernel.
The method partition the range of bandwidths into ngroups.t intervals, correspondingly subdividing the points of the pattern \code{t} into ngroups.t sub-patterns according to bandwidth, and applying fixed-bandwidth smoothing to each sub-pattern. Specifying \code{ngroups.t = 1} is the same as fixed-bandwidth smoothing with bandwidth \code{sigma = median(bw.t)}.
}
\examples{
t <- rbeta(100, 1,4,0.8)
tIntensity <- dens.par.temp(t, at = "bins")
plot(tIntensity$x, tIntensity$y, type = "l")

}
\references{
Davies, T.M. and Baddeley, A. (2018) Fast computation of spatially adaptive kernel estimates. Statistics and Computing, 28(4), 937-956.

González J.A. and Moraga P. (2018)
An adaptive kernel estimator for the intensity function of spatio-temporal point processes
\url{http://arxiv.org/pdf/2208.12026}
}
\author{
Jonatan A. González
}
