% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfa_report.R
\name{kfa_report}
\alias{kfa_report}
\title{Creates summary report from a k-fold factor analysis}
\usage{
kfa_report(
  models,
  file.name,
  report.title = file.name,
  path = NULL,
  report.format = "html_document",
  word.template = NULL,
  index = "default",
  plots = FALSE,
  load.flag = 0.3,
  cor.flag = 0.9,
  rel.flag = 0.6,
  digits = 2
)
}
\arguments{
\item{models}{an object returned from \code{\link[kfa]{kfa}}}

\item{file.name}{character; file name to create on disk.}

\item{report.title}{character; title of the report}

\item{path}{character; path of the directory where summary report will be saved. Default is working directory. \code{path} and \code{file.name} are combined to create final file path}

\item{report.format}{character; file format of the report. Default is HTML ("html_document"). See \code{\link[rmarkdown]{render}} for other options.}

\item{word.template}{character; file path to word document to use as a formatting template when \code{report.format = "word_document"}.}

\item{index}{character; one or more fit indices to summarize in the report. Use \code{\link[kfa]{index_available}} to see choices.
Chi-square value and degrees of freedom are always reported. Default is CFI and RMSEA (naive, scaled, or robust version depends on estimator used in \code{models}).}

\item{plots}{logical; should plots of the factor models be included in the report?}

\item{load.flag}{numeric; factor loadings of variables below this value will be flagged. Default is .30}

\item{cor.flag}{numeric; factor correlations above this value will be flagged. Default is .90}

\item{rel.flag}{numeric; factor (scale) reliabilities below this value will be flagged. Default is .60.}

\item{digits}{integer; number of decimal places to display in the report.}
}
\value{
A summary report of factor structures and model fit within and between folds.
}
\description{
Generates a report summarizing the factor analytic results over k-folds.
}
\examples{

# simulate data based on a 3-factor model with standardized loadings
sim.mod <- "f1 =~ .7*x1 + .8*x2 + .3*x3 + .7*x4 + .6*x5 + .8*x6 + .4*x7
                f2 =~ .8*x8 + .7*x9 + .6*x10 + .5*x11 + .5*x12 + .7*x13 + .6*x14
                f3 =~ .6*x15 + .5*x16 + .9*x17 + .4*x18 + .7*x19 + .5*x20
                f1 ~~ .2*f2
                f2 ~~ .2*f3
                f1 ~~ .2*f3
                x9 ~~ .2*x10"
set.seed(1161)
sim.data <- simstandard::sim_standardized(sim.mod, n = 900,
                                          latent = FALSE,
                                          errors = FALSE)[c(2:9,1,10:20)]

# include a custom 2-factor model
custom2f <- paste0("f1 =~ ", paste(colnames(sim.data)[1:10], collapse = " + "),
                   "\nf2 =~ ",paste(colnames(sim.data)[11:20], collapse = " + "))

\donttest{
mods <- kfa(data = sim.data,
            k = NULL, # prompts power analysis to determine number of folds
            cores = 2,
            custom.cfas = custom2f)
            }

\dontrun{
kfa_report(mods, file.name = "example_sim_kfa_report",
           report.format = "html_document",
           report.title = "K-fold Factor Analysis - Example Sim")
           }

}
