% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloader.R
\name{download_graph}
\alias{download_graph}
\title{Download KGS rank graph}
\usage{
download_graph(id, dst = tempfile(), lang = "en", country = "US",
  method = "libcurl", ...)
}
\arguments{
\item{id}{KGS ID}

\item{dst}{destination file path or directory}

\item{lang}{language code, a lower case character of length 2}

\item{country}{country code, an upper case character of length 2}

\item{method}{method to be used for downloading files. See \code{\link[utils]{download.file}} for details}

\item{...}{optional arguments for \code{\link[utils]{download.file}} other than
\code{method} and \code{mode}}
}
\value{
path to the saved file
}
\description{
Access KGS server and download the latest rank graph of the specified player.
Requires internet connection.
Returns the path to the downloaded file if succeeded.
}
\details{
Default setting downloads the English version. Another good option is
to set \code{lang='ja'} and \code{country='JP'}, which downloads the Japanese version.
}
\examples{
\dontrun{
f <- download_graph('twoeye')
p <- png::readPNG(f)
plot.new()
rasterImage(p,0,0,1,1)}
}
\seealso{
\code{\link[utils]{download.file}}
}
