% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd_classify.R
\name{ckd.kdigo_category.gfr}
\alias{ckd.kdigo_category.gfr}
\title{Calculate eGFR categories}
\usage{
ckd.kdigo_category.gfr(gfr)
}
\arguments{
\item{gfr}{Numeric vector. eGFR, expressed in "ml/min/1.73m2".}
}
\value{
string gfr category.
}
\description{
Calculate eGFR categories
}
\details{
Calculate eGFR categories (G1, G2, G3a, G3b, G4, G5) based on eGFR values.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
ckd.kdigo_category.gfr(gfr = 25)
# for a dataset - see vignettes for details
# ckd.kdigo_category.gfr(gfr = dta$egfr)
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
