% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_stats.R
\name{desc_stats}
\alias{desc_stats}
\title{Descriptive statistics}
\usage{
desc_stats(
  vector = NULL,
  output_type = "vector",
  sigfigs = 3,
  se_of_mean = FALSE,
  ci = FALSE,
  pi = FALSE,
  skewness = FALSE,
  kurtosis = FALSE,
  notify_na_count = NULL,
  print_dt = FALSE
)
}
\arguments{
\item{vector}{a numeric vector}

\item{output_type}{if \code{output_type = "vector"}, return a vector
of descriptive statistics; if \code{output_type = "dt"}, return a
data.table of descriptive statistics (default = "vector")}

\item{sigfigs}{number of significant digits to round to (default = 3)}

\item{se_of_mean}{logical. Should the standard errors around
the mean be included in the descriptive stats?
(default = FALSE)}

\item{ci}{logical. Should 95\% CI be included in the descriptive stats?
(default = FALSE)}

\item{pi}{logical. Should 95\% PI be included in the descriptive stats?
(default = FALSE)}

\item{skewness}{logical. Should the skewness statistic be included
in the descriptive stats?
(default = FALSE)}

\item{kurtosis}{logical. Should the kurtosis statistic be included
in the descriptive stats?
(default = FALSE)}

\item{notify_na_count}{if \code{TRUE}, notify how many observations
were removed due to missing values. By default, NA count will be printed
only if there are any NA values.}

\item{print_dt}{if \code{TRUE}, print the descriptive stats data.table}
}
\value{
if \code{output_type = "vector"}, the output will be a
named numeric vector of descriptive statistics;
if \code{output_type = "dt"}, the output will be data.table of
descriptive statistics.
}
\description{
Returns descriptive statistics for a numeric vector.
}
\examples{
desc_stats(1:100)
desc_stats(1:100, ci = TRUE, pi = TRUE, sigfigs = 2)
desc_stats(1:100, se_of_mean = TRUE,
ci = TRUE, pi = TRUE, sigfigs = 2,
skewness = TRUE, kurtosis = TRUE)
desc_stats(c(1:100, NA))
example_dt <- desc_stats(vector = c(1:100, NA), output_type = "dt")
example_dt
}
