% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_pairwise.R
\name{t_test_pairwise}
\alias{t_test_pairwise}
\title{t-tests, pairwise}
\usage{
t_test_pairwise(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  sigfigs = 3,
  welch = TRUE,
  cohen_d = TRUE,
  cohen_d_w_ci = TRUE,
  adjust_p = "holm",
  bonferroni = NULL,
  mann_whitney = TRUE,
  mann_whitney_exact = FALSE,
  t_test_stats = TRUE,
  sd = FALSE,
  round_p = 3,
  anova = FALSE,
  round_f = 2,
  round_t = 2,
  round_t_test_df = 2
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{sigfigs}{number of significant digits to round to}

\item{welch}{Should Welch's t-tests be conducted?
By default, \code{welch = TRUE}}

\item{cohen_d}{if \code{cohen_d = TRUE}, Cohen's d statistics will be
included in the output data.table.}

\item{cohen_d_w_ci}{if \code{cohen_d_w_ci = TRUE},
Cohen's d with 95\% CI will be included in the output data.table.}

\item{adjust_p}{the name of the method to use to adjust p-values.
If \code{adjust_p = "holm"}, the Holm method will be used;
if \code{adjust_p = "bonferroni"}, the Bonferroni method will be used.
By default, \code{adjust_p = "holm"}}

\item{bonferroni}{The use of this argument is deprecated.
Use the 'adjust_p' argument instead.
If \code{bonferroni = TRUE}, Bonferroni tests will be
conducted for t-tests or Mann-Whitney tests.}

\item{mann_whitney}{if \code{TRUE}, Mann-Whitney test results will be
included in the output data.table. If \code{FALSE}, Mann-Whitney
tests will not be performed.}

\item{mann_whitney_exact}{this is the input for the 'exact'
argument used in the 'stats::wilcox.test' function, which
conducts a Mann-Whitney test. By default, \code{
mann_whitney_exact = FALSE}. If you want to use the default settings
for the 'stats::wilcox.test' function, consider setting
\code{mann_whitney_exact = TRUE}.}

\item{t_test_stats}{if \code{t_test_stats = TRUE}, t-test statistic
and degrees of freedom will be included in the output data.table.
By default, \code{t_test_stats = TRUE}}

\item{sd}{if \code{sd = TRUE}, standard deviations will be
included in the output data.table.}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{anova}{Should a one-way ANOVA be conducted and reported?
By default, \code{anova = FALSE}, but when there are more than two
levels in the independent variable, the value will change such tat
\code{anova = TRUE}.}

\item{round_f}{number of decimal places to which to round
the f statistic (default = 2)}

\item{round_t}{number of decimal places to which to round
the t statistic (default = 2)}

\item{round_t_test_df}{number of decimal places to which to round
the degrees of freedom for t tests (default = 2)}
}
\value{
the output will be a data.table showing results of all
pairwise comparisons between levels of the independent variable.
}
\description{
Conducts a t-test for every possible pairwise comparison
with Holm or Bonferroni correction
}
\examples{
\dontrun{
# Basic example
t_test_pairwise(
data = iris, iv_name = "Species", dv_name = "Sepal.Length")
# Welch's t-test
t_test_pairwise(
data = mtcars, iv_name = "am", dv_name = "hp")
# A Student's t-test
t_test_pairwise(
data = mtcars, iv_name = "am", dv_name = "hp", welch = FALSE)
# Other examples
t_test_pairwise(data = iris, iv_name = "Species",
dv_name = "Sepal.Length", t_test_stats = TRUE, sd = TRUE)
t_test_pairwise(
data = iris, iv_name = "Species", dv_name = "Sepal.Length",
mann_whitney = FALSE)
}
}
